/*

Copyright (c) 2004 PXI Project Team

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in the
Software without restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
Software, and to permit persons to whom the Software is furnished to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies
or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include "cute_tokenizer.h"

cuteTokenizer::cuteTokenizer( void )
{
    delim = ',';
    tokens.clear();
    tokens.push_back( "" );
    char_mode = false;
	add_spaces = false;
}

cuteTokenizer::cuteTokenizer( const string &s, char d )
{
    delim = d;
    tokenize( s );
    char_mode = false;
	add_spaces = false;
}

cuteTokenizer::~cuteTokenizer( void )
{
    /* Do nothing */;
}

string cuteTokenizer::fetch_token( int x )
{
    return ( char_mode ) ? char_string.substr( x + 1, 1 ) : tokens[ x ];
}

string cuteTokenizer::fetch_token( int x, int y )
{
    string s;
    int i;
    if ( char_mode )
    {
        return char_string.substr( x , y - x + 1 );
    }
    for ( i = x;i <= y;++i )
    {
        s += tokens[ i + 1 ] + delim;
    }
    return s.substr( 0, ( int ) s.length() - 1 );
}

const cuteTokenizer &cuteTokenizer::operator=( const cuteTokenizer &c )
{
    delim = c.delim;
    tokens = c.tokens;
    return *this;
}

void cuteTokenizer::tokenize( const string &s, char d )
{
    int i, p ( 0 ), l ( ( int ) s.length() );
	string padding ( add_spaces ? " " : "" );
    delim = d;
    char_mode = false;
    for ( i = 0;i < l;++i )
    {
        if ( s[ i ] == d )
        {
            tokens.push_back( padding + s.substr( p, i - p ) + padding );
            p = i + 1;
        }
    }
    if ( p != l )
    {
        tokens.push_back( padding + s.substr( p, l - p ) + padding );
    }
}

void cuteTokenizer::tokenize( const string &s )
{
    tokenize( s, delim );
}

void cuteTokenizer::hc_tokenize( const string &s, const string &d )
{
    char_mode = false;
    if ( d == "char" )
    {
        split_chars( s );
    }
    else if ( d == "line" )
    {
        split_lines( s );
    }
    else if ( d == "word" )
    {
        split_words( s );
    }
    else if ( d == "item" )
    {
        split_items( s );
    }
}

void cuteTokenizer::split_chars( const string &s )
{
    char_mode = true;
    char_string = s;
}

void cuteTokenizer::split_lines( const string &s )
{
    tokenize( s, ( char ) 13 );
}

void cuteTokenizer::split_words( const string &s )
{
    int i, l ( ( int ) s.length() ), p ( 0 );
    bool f ( true );
    for ( i = 0;i < l;++i )
    {
        if ( s[ i ] == ' ' )
        {
            if ( !f )
            {
                f = true;
                tokens.push_back( s.substr( p, i - p ) );
            }
        }
        else
        {
            if ( f )
            {
                p = i;
                f = false;
            }
        }
    }
    if ( p != l )
    {
        tokens.push_back( s.substr( p, i - p ) );
    }
    delim = ' ';
}

void cuteTokenizer::split_items( const string &s )
{
    tokenize( s );
}

void cuteTokenizer::setDelim( char d )
{
    delim = d;
}

char cuteTokenizer::getDelim( void )
{
    return delim;
}

